#include "liveview.h"
#include <QPainter>
#include <QVector>
#include <QRgb>
#include <cstring>

LiveView::LiveView(QWidget *parent) : QWidget(parent),
    image(512,128,QImage::Format_Indexed8)
{
    QVector<QRgb> colorTable;
    for( int i = 0; i < 256; ++i )
        colorTable.push_back(qRgb(i,i,i));
    image.setColorTable(colorTable);
}

LiveView::~LiveView()
{

}

int LiveView::heightForWidth(int w) const
{
    return (w+3)/4;
}

void LiveView::saveImage(const QString& filename )
{
    image.save(filename);
}

void LiveView::setData(uint8_t *data)
{
    std::memcpy(image.bits(),data,512*128);
    update();
}

void LiveView::paintEvent(QPaintEvent *event)
{
    Q_UNUSED(event);
    QPainter painter(this);
    painter.scale(width()/512.0,width()/512.0);
    painter.drawImage(0,0,image);
}
