#include <QPlainTextEdit>
#include <boost/iostreams/stream.hpp>
#include <boost/iostreams/categories.hpp>

#ifndef LOGSTREAM_H
#define	LOGSTREAM_H

class LogStreamDevice
{
public:
    typedef char char_type;
    typedef boost::iostreams::sink_tag category;

    explicit LogStreamDevice( QPlainTextEdit* widget );
    std::streamsize write(const char *s, std::streamsize n);

private:
    QPlainTextEdit* logWidget;
};

typedef boost::iostreams::stream<LogStreamDevice> LogStream;

#endif //LOGSTREAM_H
