#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QTimer>

#include <ostream>

#include "logstream.h"
#include "swissspadstream.h"

namespace Ui {
class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

private slots:
    void on_actionQuit_triggered();
    void on_intFreq_currentIndexChanged(int refClkIndex);
    void on_folderButton_clicked();
    void settingsChanged();
    void applySettings(uint32_t flimShift = 0);
    void on_useExt_clicked(bool state);
    void on_fineShiftInc_clicked();
    void on_fineShiftDec_clicked();
    void on_fineShiftReset_clicked();
    void on_fineShiftResetPos_clicked();
    void on_previewButton_clicked();
    void on_saveButton_clicked();
    void on_loadSettingsButton_clicked();
    void on_recordButton_clicked();
    void recSequence(uint32_t flimShift = 0);
    void on_doFLIM_clicked();
    void updatePreview();
    void contrastChanged();
    void updateStatus();
    void on_tabWidget_currentChanged(int index);

    void on_capFalling_clicked(bool checked);
    void on_capCal_clicked();
    void on_capReset_clicked();
    void on_capInc_clicked();
    void on_capDec_clicked();
    void on_voidWarranty_clicked(bool checked);

private:
    Ui::MainWindow *ui;
    SwissSPADStream fx3;

    LogStream cout;

    QTimer *previewTimer;
    QTimer *statusTimer;

    enum GateMode { PATTERN_MODE = 0, CLASSIC_MODE = 1 };
    GateMode lastMode;
    uint32_t classicRepetitions, patternRepetitions;
    uint32_t wordsPerFrame, frameTimeout;

    void writeSettings( std::ostream& config );
    void loadSettings( const std::string& filename );

    void fx3Connected();
    void fx3Disconnected();
    void fx3Open();
    void fx3Reset();
    uint32_t fx3GetLinkQuality();
    void fx3ReadTimestamp();
    void fx3ReadStatus(bool print=false);
    double fx3GetPhase();
    void fx3SyncClock(bool external);
    void fx3GetPreview();
};

#endif // MAINWINDOW_H
