#ifndef PATTERNINPUT_H
#define PATTERNINPUT_H

#include <QWidget>
#include <QVector>
#include <QPushButton>

class PatternInput : public QWidget
{
    Q_OBJECT
public:
    explicit PatternInput(QWidget *parent = 0);
    ~PatternInput();

    virtual int heightForWidth(int w) const;

    void getPattern( uint64_t& spadoff, uint64_t& recharge, uint64_t& gate, bool truncate = true );
    void getRotatedPattern( uint64_t& spadoff, uint64_t& recharge, uint64_t& gate, uint32_t amount = 0, bool truncate = true );
    void setSpadoff( uint64_t p );
    void setRecharge( uint64_t p );
    void setGate( uint64_t p );

signals:

public slots:
    void setSegments(int count);

private:
    int segments;
    QVector<QPushButton*> spadoffButtons;
    QVector<QPushButton*> rechargeButtons;
    QVector<QPushButton*> gateButtons;
};

#endif // PATTERNINPUT_H
